import 'package:buecher/providers/book_provider.dart';
import 'package:buecher/screens/book_list_screen.dart';
import 'package:flutter/material.dart';
import 'package:provider/provider.dart';

void main() {
  runApp(
    MultiProvider(
      providers: [
        ChangeNotifierProvider(create: (_) => BookProvider()),
      ],
      child: const MyApp(),
    ),
  );
}

class MyApp extends StatelessWidget {
  const MyApp({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      title: 'Bücherregal',
      theme: ThemeData(
        primarySwatch: Colors.blue,
      ),
      home: const BookListScreen(), // Hauptseite der App
    );
  }
}
