class Book {
  int? id;
  String title;
  String author;
  int rating;
  String status;
  String notes;

  Book({
    this.id,
    required this.title,
    required this.author,
    required this.rating,
    required this.status,
    required this.notes,
  });

  // Wandelt ein Book in eine Map um, um es in die Datenbank einzufügen.
  Map<String, dynamic> toMap() {
    return {
      'id': id,
      'title': title,
      'author': author,
      'rating': rating,
      'status': status,
      'notes': notes,
    };
  }

  // Erzeugt ein Book-Objekt aus einer Map (z.B. aus der DB gelesen).
  factory Book.fromMap(Map<String, dynamic> map) {
    return Book(
      id: map['id'] as int?,
      title: map['title'] as String,
      author: map['author'] as String,
      rating: map['rating'] as int,
      status: map['status'] as String,
      notes: map['notes'] as String,
    );
  }

  @override
  String toString() {
    return "Book(id: $id, title: '$title', author: '$author')";
  }
}
